#!/usr/bin/env python3
# -*- coding:utf-8 -*-
###
# File: /data/zhangruochi/projects/molgen/models/model_loaders.py
# Project: /mnt/data/zhangruochi/DeepOrchestration/models
# Created Date: Wednesday, October 6th 2021, 12:23:13 am
# Author: Ruochi Zhang
# Email: zrc720@gmail.com
# -----
# Last Modified: Mon Sep 29 2025
# Modified By: Ruochi Zhang
# -----
# Copyright (c) 2021 Bodkin World Domination Enterprises
#
# MIT License
#
# Copyright (c) 2021 Ruochi Zhang Ltd
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of
# this software and associated documentation files (the "Software"), to deal in
# the Software without restriction, including without limitation the rights to
# use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
# of the Software, and to permit persons to whom the Software is furnished to do
# so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.
# -----
###
import torch
from omegaconf import DictConfig
from .baseline import DeepOrBase
from .deepor import DeepOr


def model_preperation(cfg: DictConfig) -> torch.nn.Module:

    # Modeling
    if cfg.model.name == "baseline":
        net = DeepOrBase(input_dim=cfg.model.baseline.input_dim,
                         hidden_dim=cfg.model.baseline.hidden_dim,
                         num_layers=cfg.model.baseline.num_layers,
                         nhead=cfg.model.baseline.nhead)

    elif cfg.model.name == "deepor":
        net = DeepOr(input_dim=cfg.model.deepor.input_dim,
                     time_steps=cfg.model.deepor.time_steps,
                     latent_dim=cfg.model.deepor.latent_dim,
                     tranformer_layers=cfg.model.deepor.tranformer_layers,
                     decoder_nhead=cfg.model.deepor.decoder_nhead,
                     dim_feedforward=cfg.model.deepor.dim_feedforward,
                     setpoint=cfg.model.deepor.setpoint,
                     temperature=cfg.model.deepor.temperature,
                     Kp=cfg.model.deepor.Kp,
                     Ki=cfg.model.deepor.Ki,
                     Kd=cfg.model.deepor.Kd,
                     min_temp=cfg.model.deepor.min_temp,
                     max_temp=cfg.model.deepor.max_temp,
                     head_hidden=cfg.model.deepor.head_hidden)

    # if len(cfg.train.device_ids) > 1:
    #     net = torch.nn.DataParallel(net,
    #                                 device_ids=cfg.train.device_ids,
    #                                 dim=1)

    net.to(device=torch.device("cuda:{}".format(cfg.train.device_ids[0]) if (
        torch.cuda.is_available() and len(cfg.train.device_ids) > 0
    ) else "cpu"))

    return net
