#!/usr/bin/env python3
# -*- coding:utf-8 -*-
###
# File: /data/zhangruochi/projects/AAAI/FairCare/loss.py
# Project: /mnt/data/zhangruochi/DeepOrchestration/utils
# Created Date: Saturday, January 22nd 2022, 6:01:17 pm
# Author: Ruochi Zhang
# Email: zrc720@gmail.com
# -----
# Last Modified: Mon Sep 29 2025
# Modified By: Ruochi Zhang
# -----
# Copyright (c) 2022 Bodkin World Domination Enterprises
#
# MIT License
#
# Copyright (c) 2022 Ruochi Zhang Ltd
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of
# this software and associated documentation files (the "Software"), to deal in
# the Software without restriction, including without limitation the rights to
# use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
# of the Software, and to permit persons to whom the Software is furnished to do
# so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.
# -----
###
import torch
import torch.nn.functional as F


class LossFunction():

    def __init__(self, device):

        self.class_loss_func = torch.nn.BCELoss()

    def __call__(self, pre_logits, true_label):
        loss = self.class_loss_func(pre_logits.squeeze(-1), true_label)
        loss_dict = {}
        loss_dict["total_loss"] = loss

        return loss_dict


class DeepOrLoss():

    def __init__(self, device, alpha=1.0, beta=1.0, gamma=1.0):

        self.alpha = alpha
        self.beta = beta
        self.gamma = gamma
        self.device = device

        self.bce_loss = torch.nn.BCELoss()

    def __call__(self, X, logits, reconstruct_repr, latent_ata, latent_dgfs,
                 target):

        prediction_loss = self.bce_loss(logits.squeeze(-1), target)
        # consistency loss
        cosine_sim = F.cosine_similarity(latent_dgfs, latent_ata,
                                         dim=-1).mean()
        consistency_loss = 1 - cosine_sim

        # reconstruction loss
        reconstruction_loss = F.mse_loss(reconstruct_repr, X)

        # # 稀疏性损失 (L0正则化)
        # sparsity_loss = sparse_weights.sum()

        # all losses
        total_loss = (prediction_loss + self.alpha * consistency_loss +
                      self.beta * reconstruction_loss)

        loss_dict = {
            "total_loss": total_loss,
            "prediction_loss": prediction_loss,
            "consistency_loss": consistency_loss,
            "reconstruction_loss": reconstruction_loss
        }

        return loss_dict
